(*********************************************************************************
* Copyright: Bernecker+Rainer
* Author:    Mikael Regard
* Created:   May 13, 2019/8:21 AM 
* Updated:   Aug 19, 2019/09:00 AM
 *********************************************************************************
 * Description:
 * FuB to move Xbot 6 degrees of freedom motion.
 * 
 *Input:
 * MsgFrame     (Profinet output frame)
 * ReadFrame    (Profinet reply frame)
 * Execute      (Edgepos, Execute = TRUE will run the FuB once)
 * Cmd Label    (Optional 2 byte Command label. Used to identify specfic commands. 
 * Xbot ID      (Xbot to Move. XbotID > 0. Can only move 1 at the time. Virtual Axis ID 100-127, Macro ID 128-191
 * TargetX      (Absolute Target X Position in mm)
 * TargetY      (Absolute Target Y Position in mm)
 * TargetZ      (Absolute Target X Position in mm)
 * TargetRX      (Absolute Target Y Position in rad)
 * TargetRY      (Absolute Target X Position in rad)
 * TargetRZ      (Absolute Target Y Position in rad)
 * 
 *
 * Output:
 * Error (Indicates if there is an error)
 * Busy  (FuB will be Busy until reply)
 * Done  (When Accepted command is received, Done = TRUE)
 * TravelTime (Expected travel time)
 * ErrorID (0x0001 = System Error, 0x2000 = Wrong PMC State, 0x2001 = No Mastership, 0x2002 = Mastership timeout,
 *		    0x2003 = Wrong group state, 0x2004 = Wrong Macro state, 0x2005 = Wrong Digital IO state,
 *          0x2006 = Wrong flyways state, 0x3000 = Wrong Xbot state, 0x4000 = Paramter Error: Invalid Parameters.
 *********************************************************************************)






FUNCTION_BLOCK PM_6DOFMotion
	// Check Reply
	IF(Busy)THEN
		brsmemcpy(ADR(CmdLbl),ADR(ReadFrame[3]),2);
		IF(ReadFrame[0] = CmdCount AND
			ReadFrame[1] 	= 16  AND
			ReadFrame[2]	= 11 AND
			CmdLbl = CmdLabel)THEN
			Done 	:= TRUE;
			Busy 	:= FALSE;
			brsmemcpy(ADR(ErrorID),ADR(ReadFrame[5]),2);
			Error 	:= UINT_TO_BOOL(ErrorID);
			Done 	:= NOT(UINT_TO_BOOL(ErrorID));
			brsmemcpy(ADR(TravelTime),ADR(ReadFrame[12]),4);
		ELSE
			Busy := FALSE;
		END_IF;
	END_IF;
	//Send Command		
	IF(Execute AND NOT(Done) AND NOT(Error))THEN
		IF(NOT(Busy))THEN
			brsmemset(ADR(MsgFrame[1]),FALSE,98);
			CmdCount 		:= ReadFrame[0] +1;
			MsgFrame[0] 	:= CmdCount; 
			MsgFrame[1] 	:= 16;
			MsgFrame[2] 	:= 11;
			brsmemcpy(ADR(MsgFrame[3]), ADR(CmdLabel), 2);
			MsgFrame[5]		:= 1;
			MsgFrame[9] 	:= XbotID;		
			
			Xmm2m			:= TargetX/1000.0;
			Ymm2m			:= TargetY/1000.0;
			Zmm2m 			:= TargetZ/1000.0;
			RXmrad2rad		:= TargetRX/1000.0;
			RYmrad2rad		:= TargetRY/1000.0;
			RZmrad2rad		:= TargetRZ/1000.0;
			
			brsmemcpy(ADR(MsgFrame[12]), ADR(Xmm2m), 4);
			brsmemcpy(ADR(MsgFrame[16]), ADR(Ymm2m), 4);
			brsmemcpy(ADR(MsgFrame[20]), ADR(Zmm2m), 4);
			brsmemcpy(ADR(MsgFrame[24]), ADR(RXmrad2rad), 4);
			brsmemcpy(ADR(MsgFrame[28]), ADR(RYmrad2rad), 4);
			brsmemcpy(ADR(MsgFrame[32]), ADR(RZmrad2rad), 4);	
			Busy 			:= TRUE;	
		END_IF;
		
	ELSIF(NOT(Execute))THEN
		Busy 	:= FALSE;
		Done 	:= FALSE;
		Error 	:= FALSE;
		ErrorID := 0;
	END_IF
	
	
	
END_FUNCTION_BLOCK
